﻿/*
Copyright (c) 2023 Inumi Maruno

Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
*/

"use strict";const canvas=document.getElementById("game_canvas"),context=canvas.getContext("2d"),ORIGINAL_WIDTH=760,ORIGINAL_HEIGHT=570,MAIN_WIDTH=600,MAIN_HEIGHT=400,DETAIL_SIZE=300,DETAIL_OFFSET_X=150,DETAIL_OFFSET_Y=50,ITEM_SIZE=80,ITEM_OFFSET=10;let logmode=!1;function TraceLog(e){logmode&&console.log(e)}function Logmode(){logmode=!0}function clearCanvas(){objects=[],context.clearRect(0,0,canvas.width,canvas.height)}function clearMessageCanvas(){context.clearRect(0,400,600,170)}function clearMainCanvas(){objects=[],context.clearRect(0,0,600,400)}function clearItemCanvas(){context.clearRect(600,0,160,570)}let ViewRatio=1;function FitView(){let e=document.documentElement.clientWidth,t=document.documentElement.clientHeight;e/t>4/3?(canvas.style.height=.8*t+"px",ViewRatio=.8*t/570):(canvas.style.width=.8*e+"px",ViewRatio=.8*e/760)}function getRandomValue(e){return Math.floor(Math.random()*e)}function LockScreen(){items_on_hand=[],objects=[]}function UnLockScreen(){itemManager.updateItemCanvas(),sceneManager.RedrawScreen()}FitView();let images=[];function AddImage(e,t){images[e]={path:t}}let discard_mouse_event=!1;function PrepareGame(){loadImages(),messageManager.loadSEs(),messageManager.loadBgms(),canvas.addEventListener("touchstart",e=>{discard_mouse_event=!0,ClickCB(e)}),canvas.addEventListener("mousedown",e=>{discard_mouse_event||ClickCB(e)})}let objects=[],items_on_hand=[];function ClickCB(e){for(let t=objects.length-1;t>=0&&!objects[t].click(e);t--);for(name in items_on_hand)if(items_on_hand[name].click(e))break}function loadImages(){for(name in images){let e=new Image;e.src=images[name].path,images[name].image=e,e.onload=()=>{LoadedCB()}}messageManager.SetMessageBG("MessageBG"),itemManager.SetItemBG("ItemBG")}let loaded_count=0,started=!1;function LoadedCB(){if(started)return;loaded_count++,clearCanvas(),context.font="16px 'ＭＳ ゴシック'",context.textBaseline="middle";let e=Object.keys(images).length+messageManager.GetSoundCount(),t="NOW LOADING..."+Math.round(loaded_count/e*100)+"%";context.fillText(t,100,285),loaded_count!=e||sceneManager.MoveScene("Title")||FinishTitle()}function FinishTitle(){StartGame(),messageManager.PlayBGM("MAINBGM"),messageManager.showMessageBG(),itemManager.updateItemCanvas(),started=!0}class FlagManager{#a=[];AddFlag(e,t){if("boolean"!=typeof t){TraceLog(e+":should be boolean.");return}this.#a[e]=t}GetFlag(e){return this.#a[e]}}let flagManager=new FlagManager;class SceneManager{#b=[];AddScene(e,t,s){this.#b[e]={bg:t,func:s}}latestMoveFunction=void 0;MoveScene(e){if(TraceLog("Scene:"+e),void 0==this.#b[e])return TraceLog("This scene is not set"),!1;this.ShowBG(this.#b[e].bg),this.#b[e].func();let t=e,s=this;return this.latestMoveFunction=()=>s.MoveScene(t),!0}ShowBG(e){TraceLog("BG:"+e),clearMainCanvas(),context.drawImage(images[e].image,0,0)}scene_interval;MoveSceneSlow(e){TraceLog("Scene(slow):"+e),LockScreen(),this.scene_interval=setTimeout(this.DrawWhiteSlow,100,e,0,this)}DrawWhiteSlow(e,t,s){context.beginPath(),context.rect(0,0,600,400),context.fillStyle="rgba(255, 255, 255,"+.025*t+") ",context.closePath(),context.fill(),t<20?s.scene_interval=setTimeout(s.DrawWhiteSlow,100,e,t+1,s):s.scene_interval=setTimeout(s.DrawImageSlow,100,e,0,s)}DrawImageSlow(e,t,s){if(clearMainCanvas(),context.drawImage(images[s.#b[e].bg].image,0,0),context.beginPath(),context.rect(0,0,600,400),context.fillStyle="rgba(255, 255, 255,"+(1-.025*t)+") ",context.closePath(),context.fill(),t<40)s.scene_interval=setTimeout(s.DrawImageSlow,100,e,t+1,s);else{let a=e,n=s;s.latestMoveFunction=()=>n.MoveScene(a),s.#b[e].func(),UnLockScreen()}}RedrawScreen(){this.latestMoveFunction()}AddDefaultLR(e,t){this.addClickRectObject(0,0,40,400,"rgba(0, 0, 0, 0.2)",e),this.addClickRectObject(560,0,40,400,"rgba(0, 0, 0, 0.2)",t)}AddDefaultD(e){this.addClickRectObject(0,360,600,40,"rgba(0, 0, 0, 0.2)",e)}addClickRectObject(e,t,s,a,n,i){context.beginPath(),context.rect(e,t,s,a),context.closePath(),context.fillStyle=n,context.fill();let o=new screenObj(e,t,e+s,t+a,i);objects.push(o)}AddObject(e,t,s,a){if(context.drawImage(images[e].image,t,s),void 0==a)return;let n=new screenObj(t,s,t+images[e].image.width,s+images[e].image.height,a);objects.push(n)}AddEmptyObject(e,t,s,a,n){let i=new screenObj(e,t,s,a,n);objects.push(i)}#c=[];AddCounter(e,t,s){let a=new CounterObj(t,s);this.#c[e]=a}ShowCounter(e,t,s){this.#c[e].show(t,s)}GetCurrentCounterIndex(e){return this.#c[e].getCurrentNumber()}SetCurrentCounterIndex(e,t){this.#c[e].setCurrentNumber(t)}GetCurrentCounterName(e){return this.#c[e].getCurrentName()}}let sceneManager=new SceneManager;class ItemManager{#d=[];AddItem(e,t){this.#d[e]={image_name:t,have:!1,current:!1,used:!1}}IsHave(e){return this.#d[e].have}SetUsed(e,t){this.#d[e].used=t,this.#d[e].current=!1,this.updateItemCanvas()}IsCurrent(e){return this.#d[e].current}GetItem(e){messageManager.PlaySE("ITEMGET"),this.#d[e].have=!0,this.updateItemCanvas()}#e;SetItemBG(e){this.#e=e}updateItemCanvas(){clearItemCanvas(),void 0!=images[this.#e]&&context.drawImage(images[this.#e].image,600,0),items_on_hand=[];let e=0;for(let t in this.#d)if(this.#d[t].have&&!this.#d[t].used){let s=610;e%2==1&&(s+=80);let a=80*Math.floor(e/2)+10;context.drawImage(images[this.#d[t].image_name].image,s,a),e++;let n=t,i=this,o=function(){if(i.#d[n].current)i.ShowItemDetail(n);else{for(t in i.#d)i.#d[t].current=!1;i.#d[n].current=!0,i.updateItemCanvas()}},r=new screenObj(s-10,a-10,s-10+80,a-10+80,o);items_on_hand.push(r),this.#d[t].current&&(context.beginPath(),context.rect(s,a,60,60),context.fillStyle="rgba(255, 0, 0, 0.2)",context.closePath(),context.fill())}}AddItemDetail(e,t,s){void 0==this.#d[e]&&(this.#d[e]={}),this.#d[e].detail_image=t,this.#d[e].detail_func=s}#f=!1;ShowItemDetail(e){TraceLog("Item detail:"+e),void 0!=this.#d[e].detail_image&&(objects=[],this.#f?sceneManager.AddEmptyObject(0,0,600,400,()=>{this.#f=!1,sceneManager.RedrawScreen()}):sceneManager.addClickRectObject(0,0,600,400,"rgba(0, 0, 0, 0.6)",()=>{this.#f=!1,sceneManager.RedrawScreen()}),this.#f=!0,context.drawImage(images[this.#d[e].detail_image].image,150,50),this.#d[e].detail_func())}AddEmptyObject(e,t,s,a,n){this.#f&&sceneManager.AddEmptyObject(e+150,t+50,s+150,a+50,n)}}let itemManager=new ItemManager;function DrawSeparater(){context.beginPath(),context.moveTo(600,0),context.lineTo(600,570),context.closePath(),context.stroke(),context.beginPath(),context.moveTo(0,400),context.lineTo(600,400),context.closePath(),context.stroke()}class MessageManager{constructor(){let e=document.getElementById("volume");if(void 0!=e){let t=this;e.addEventListener("change",()=>{t.#g=e.value,t.#h()}),t.#g=e.value}}showMessageBG(e){void 0==e&&(e=this),clearMessageCanvas(),void 0!=images[e.#i]&&context.drawImage(images[e.#i].image,0,400)}#i;SetMessageBG(e){this.#i=e}msg_timer;ShowMessage(e){void 0!=this.msg_timer&&clearTimeout(this.msg_timer),this.showMessageBG(),context.font="18px 'ＭＳ ゴシック'",context.textBaseline="middle",context.textAlign="center",context.fillStyle="black";let t=context.measureText(e),s=t.actualBoundingBoxDescent+t.actualBoundingBoxAscent+5,a=e.split("\n"),n=485;2==a.length&&(n-=s/2),3==a.length&&(n-=s),a.length>=4&&(n-=s+s/2);for(let i=0;i<a.length;i++)context.fillText(a[i],300,n+s*i);this.msg_timer=setTimeout(this.showMessageBG,3e3,this)}#j=[];AddSe(e,t,s){void 0==s&&(s=1);let a={path:t,default_volume:s};this.#j[e]=a}GetSoundCount(){return Object.keys(this.#j).length+Object.keys(this.#k).length}loadSEs(){for(name in this.#j){let e=new Audio;e.src=this.#j[name].path,this.#j[name].audio=e,e.load(),e.oncanplay=()=>{LoadedCB()}}}PlaySound(e){if(void 0==e){TraceLog("This suound is not set.");return}e.currenttime=0;let t=e.default_volume*this.#g;t>1&&(t=1),e.audio.volume=t,e.audio.play()}#g=1;PlaySE(e){TraceLog("SE:"+e),this.PlaySound(this.#j[e])}#k=[];AddBgm(e,t,s){void 0==s&&(s=1);let a={path:t,default_volume:s};this.#k[e]=a}loadBgms(){for(name in this.#k){let e=new Audio;e.src=this.#k[name].path,e.loop=!0,this.#k[name].audio=e,e.load(),e.oncanplay=()=>{LoadedCB()}}}PlayBGM(e){TraceLog("BGM:"+e),this.PlaySound(this.#k[e])}StopBGM(){for(name in this.#k){let e=this.#k[name].default_volume*this.#g;e>1&&(e=1),this.#k[name].audio.pause()}}#h(){for(name in this.#k){let e=this.#k[name].default_volume*this.#g;e>1&&(e=1),this.#k[name].audio.volume=e}}}let messageManager=new MessageManager;class CounterObj{#l;#m;constructor(e,t){this.#l=e,this.#m=t}getCurrentNumber(){return this.#m}setCurrentNumber(e){this.#m=e,sceneManager.RedrawScreen()}getCurrentName(){return this.#l[this.#m]}show(e,t){context.drawImage(images[this.#l[this.#m]].image,e,t);let s=this,a=()=>{s.#m++,s.#m>=s.#l.length&&(s.#m=0),sceneManager.RedrawScreen()},n=new screenObj(e,t,e+images[this.#l[this.#m]].image.width,t+images[this.#l[this.#m]].image.height,a);objects.push(n)}}class screenObj{#n;#o;#p;#q;#r;constructor(e,t,s,a,n){this.#n=e,this.#o=t,this.#p=s,this.#q=a;let i=n;"function"!=typeof n&&(i=n.startsWith("MESSAGE:")?()=>{messageManager.ShowMessage(n.slice(8))}:()=>{sceneManager.MoveScene(n)}),this.#r=i}#s(t,s){return!!(t<=this.#p)&&!!(t>=this.#n)&&!!(s<=this.#q)&&!!(s>=this.#o)}#t(a){if(void 0==a.touches)return;if(0==a.touches.length){a.offsetX=this.lastOffsetX,a.offsetY=this.lastOffsetY;return}let n=a.target.getBoundingClientRect(),i=a.touches[0].clientX-window.pageXOffset-n.left,o=a.touches[0].clientY-window.pageYOffset-n.top;a.offsetX=i,a.offsetY=o,this.lastOffsetX=i,this.lastOffsetY=o}#u(r){return r/ViewRatio}click(e){return this.#t(e),!!this.#s(this.#u(e.offsetX),this.#u(e.offsetY))&&void 0!=this.#r&&!1!=this.#r(e,this)}}